<?php

namespace App\Controllers;

use App\Libraries\PanelAPI;

class Discover extends BaseController {
    
    public function __construct(){
        $this->panel = new PanelAPI();
    }
    
    public function index() {
        
        $data = [ 
            'mata_title' => 'Discover',
            'menu_active' => 'discover'
        ];
        
        $data['home_data'] = $this->panel->getHome();
        
        $data['details'] = $this->panel->getWebDetails();
        $data['sidebar']  = $this->panel->getSidebar();
        return view('discover', $data);
    }
    
    public function radios_index() {
        
        $data = [
            'mata_title' => 'Radios',
            'menu_active' => 'radios'
        ];
        
        $data['radio_page_name'] = '';
        $data['radio_data'] =  $this->panel->getRadios();
        
        $data['details'] = $this->panel->getWebDetails();
        $data['sidebar']  = $this->panel->getSidebar();
        return view('radios', $data);
    }
    
    public function categories_index(){
        
        $data = [ 
            'mataTitle' => 'Categories',
            'menu_active' => 'categories'
        ];
        
        $data['category_data'] = $this->panel->getCategory();
        
        $data['details'] = $this->panel->getWebDetails();
        $data['sidebar']  = $this->panel->getSidebar();
        return view('categories', $data);
    }
    
    public function countries_index(){
        
        $data = [ 
            'mataTitle' => 'Countries',
            'menu_active' => 'countries'
        ];
        
        $data['countries_data'] = $this->panel->getCountries();
        
        $data['details'] = $this->panel->getWebDetails();
        $data['sidebar']  = $this->panel->getSidebar();
        return view('countries', $data);
    }
    
    public function podcast_index(){
        
        $data = [
            'mataTitle' => 'Podcast',
            'menu_active' => 'podcast'
        ];
        
        $data['podcast_data'] = $this->panel->getPodcast();
        
        $data['details'] = $this->panel->getWebDetails();
        $data['sidebar']  = $this->panel->getSidebar();
        return view('podcast', $data);
    }
    
    public function categories($name, $cat_id) {
        
        $data = [ 
            'mataTitle' => 'Category : ' .$name,
            'menu_active' => 'none'
        ];
        
        $data['radio_data'] = $this->panel->getCategoriesBy($cat_id);
        
        $data['details'] = $this->panel->getWebDetails();
        $data['sidebar']  = $this->panel->getSidebar();
        return view('radios', $data);
    }
    
    public function countries($name, $countries_id) {
        
        $data = [ 
            'mataTitle' => 'Country : ' .$name,
            'menu_active' => 'none'
        ];
        
        $data['radio_data'] = $this->panel->getCountriesBy($countries_id);
        
        $data['details'] = $this->panel->getWebDetails();
        $data['sidebar']  = $this->panel->getSidebar();
        return view('radios', $data);
    }
    
    public function banner($name, $banner_id) {
        
        $data = [ 
            'mataTitle' => 'Banner : ' .$name,
            'menu_active' => 'none'
        ];
        
        $data['radio_data'] = $this->panel->getBannerBy($banner_id);
        
        $data['details'] = $this->panel->getWebDetails();
        $data['sidebar']  = $this->panel->getSidebar();
        return view('radios', $data);
    }
    
    public function search_index() {
        
        $search_test = ($this->request->getVar('q')) ? $this->request->getVar('q') : "";
        
        $data = [ 
            'mataTitle' => 'Search : '.$search_test,
            'menu_active' => 'search'
        ];
        
        $data['radio_data'] = $this->panel->getSearch($search_test);
        
        $data['details'] = $this->panel->getWebDetails();
        $data['sidebar']  = $this->panel->getSidebar();
        return view('radios', $data);
    }
 
    public function about_index(){
        
        $settings_data =  $this->panel->getWebDetails();
        
        $data = [
            'mataTitle' => $settings_data['about_page_title'],
            'menu_active' => 'about',
            'page_content' => $settings_data['about_content']
        ];
        
        $data['details'] = $this->panel->getWebDetails();
        $data['sidebar']  = $this->panel->getSidebar();
        return view('privacy_policy', $data);
    }
    
    public function policy_index(){
        
        $settings_data = $this->panel->getWebDetails();
        
        $data = [
            'mataTitle' => $settings_data['privacy_page_title'],
            'menu_active' => 'policy',
            'page_content' => $settings_data['privacy_content']
        ];
        
        $data['details'] = $this->panel->getWebDetails();
        $data['sidebar']  = $this->panel->getSidebar();
        return view('privacy_policy', $data);
    }
    
    public function terms_index(){
        
        $settings_data = $this->panel->getWebDetails();
        
        $data = [ 
            'mataTitle' => $settings_data['terms_of_use_page_title'],
            'menu_active' => 'terms',
            'page_content' => $settings_data['terms_of_use_content']
        ];
        
        $data['details'] = $this->panel->getWebDetails();
        $data['sidebar']  = $this->panel->getSidebar();
        return view('privacy_policy', $data);
    }
}
